import { useState } from 'react';
import { ProjectList } from './components/ProjectList';
import { FileTree } from './components/FileTree';
import { CodeEditor } from './components/CodeEditor';
import { AIChat } from './components/AIChat';
import { Code2 } from 'lucide-react';
import type { Project, File } from './lib/supabase';

function App() {
  const [selectedProject, setSelectedProject] = useState<Project | null>(null);
  const [selectedFile, setSelectedFile] = useState<File | null>(null);
  const [filesVersion, setFilesVersion] = useState(0);

  function handleFilesChange() {
    setFilesVersion(v => v + 1);
  }

  function handleSaveFile() {
    handleFilesChange();
  }

  return (
    <div className="h-screen flex flex-col bg-slate-900">
      <header className="bg-slate-950 border-b border-slate-800 px-6 py-3 flex items-center gap-3">
        <Code2 size={24} className="text-blue-400" />
        <h1 className="text-lg font-bold text-slate-100">AI Project Manager</h1>
        <span className="text-xs text-slate-500">Code • Build • Deploy with AI</span>
      </header>

      <div className="flex-1 flex overflow-hidden">
        <ProjectList onSelectProject={setSelectedProject} />

        {selectedProject ? (
          <>
            <FileTree
              project={selectedProject}
              selectedFile={selectedFile}
              onSelectFile={setSelectedFile}
              onFilesChange={handleFilesChange}
            />

            {selectedFile ? (
              <CodeEditor file={selectedFile} onSave={handleSaveFile} />
            ) : (
              <div className="flex-1 flex items-center justify-center bg-slate-900 text-slate-500">
                <div className="text-center">
                  <Code2 size={64} className="mx-auto mb-4 opacity-50" />
                  <p className="text-lg">Select a file to start editing</p>
                  <p className="text-sm mt-2">or create a new file using the button above</p>
                </div>
              </div>
            )}

            <AIChat project={selectedProject} onFilesGenerated={handleFilesChange} />
          </>
        ) : (
          <div className="flex-1 flex items-center justify-center bg-slate-900 text-slate-500">
            <div className="text-center">
              <Code2 size={64} className="mx-auto mb-4 opacity-50" />
              <p className="text-lg">Select or create a project to get started</p>
              <p className="text-sm mt-2">Build amazing things with AI assistance</p>
            </div>
          </div>
        )}
      </div>
    </div>
  );
}

export default App;
